/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls;

import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.controls.ScreenControlType;
import net.montoyo.wd.controls.builtin.AutoVolumeControl;
import net.montoyo.wd.controls.builtin.ClickControl;
import net.montoyo.wd.controls.builtin.JSRequestControl;
import net.montoyo.wd.controls.builtin.KeyTypedControl;
import net.montoyo.wd.controls.builtin.LaserControl;
import net.montoyo.wd.controls.builtin.ManageRightsAndUpdgradesControl;
import net.montoyo.wd.controls.builtin.ModifyFriendListControl;
import net.montoyo.wd.controls.builtin.OwnerControl;
import net.montoyo.wd.controls.builtin.ScreenModifyControl;
import net.montoyo.wd.controls.builtin.SetURLControl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;

public class ScreenControlRegistry {
    private static final HashMap<ResourceLocation, ScreenControlType<?>> CONTROL_TYPES = new HashMap();

    public static void register(ResourceLocation name, ScreenControlType<?> type) {
        if (CONTROL_TYPES.containsKey(name)) {
            Log.warning("ScreenControlRegistry#CONTROL_TYPES already contains an entry with name " + name, new Object[0]);
            throw new IllegalArgumentException("Cannot have two entries with the same name.");
        }
        CONTROL_TYPES.put(name, type);
        if (!FMLEnvironment.production && FMLEnvironment.dist.isClient()) {
            boolean shouldThrow = false;
            try {
                Dist d;
                Method m = type.clazz.getMethod("handleClient", BlockPos.class, BlockSide.class, TileEntityScreen.class, NetworkEvent.Context.class);
                OnlyIn onlyIn = m.getAnnotation(OnlyIn.class);
                if (onlyIn == null) {
                    shouldThrow = true;
                }
                if ((d = onlyIn.value()) != Dist.CLIENT) {
                    shouldThrow = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (shouldThrow) {
                Log.warning("handleClient on ScreenControl classes MUST be marked with `@OnlyIn(Dist.CLIENT)`, but it is not on " + type.clazz, new Object[0]);
                throw new IllegalStateException("handleClient on ScreenControl classes MUST be marked with `@OnlyIn(Dist.CLIENT)`, but it is not on " + type.clazz);
            }
        }
    }

    public static ScreenControl parse(FriendlyByteBuf buf) {
        return ScreenControlRegistry.CONTROL_TYPES.get((Object)new ResourceLocation((String)buf.m_130277_())).deserializer.apply(buf);
    }

    public static void init() {
    }

    static {
        ScreenControlRegistry.register(SetURLControl.id, new ScreenControlType<SetURLControl>(SetURLControl.class, SetURLControl::new));
        ScreenControlRegistry.register(KeyTypedControl.id, new ScreenControlType<KeyTypedControl>(KeyTypedControl.class, KeyTypedControl::new));
        ScreenControlRegistry.register(AutoVolumeControl.id, new ScreenControlType<AutoVolumeControl>(AutoVolumeControl.class, AutoVolumeControl::new));
        ScreenControlRegistry.register(JSRequestControl.id, new ScreenControlType<JSRequestControl>(JSRequestControl.class, JSRequestControl::new));
        ScreenControlRegistry.register(LaserControl.id, new ScreenControlType<LaserControl>(LaserControl.class, LaserControl::new));
        ScreenControlRegistry.register(ScreenModifyControl.id, new ScreenControlType<ScreenModifyControl>(ScreenModifyControl.class, ScreenModifyControl::new));
        ScreenControlRegistry.register(ModifyFriendListControl.id, new ScreenControlType<ModifyFriendListControl>(ModifyFriendListControl.class, ModifyFriendListControl::new));
        ScreenControlRegistry.register(ManageRightsAndUpdgradesControl.id, new ScreenControlType<ManageRightsAndUpdgradesControl>(ManageRightsAndUpdgradesControl.class, ManageRightsAndUpdgradesControl::new));
        ScreenControlRegistry.register(ClickControl.id, new ScreenControlType<ClickControl>(ClickControl.class, ClickControl::new));
        ScreenControlRegistry.register(OwnerControl.id, new ScreenControlType<OwnerControl>(OwnerControl.class, OwnerControl::new));
    }
}

